//-----------------------------------------------------------------------------
// 大地图对话
//-----------------------------------------------------------------------------

Window_Message.prototype.updatePlacement = function () {
    this._positionType = $gameMessage.positionType();
    if (this._positionType == 0) this.y = (Graphics.boxHeight - this.height) - 8;
    else
        this.y = this._positionType * (Graphics.boxHeight - this.height) / 2;
    this._goldWindow.y = this.y > 0 ? 0 : Graphics.boxHeight - this._goldWindow.height;
};

Window_Message.prototype.initMembers = function () {
    this._imageReservationId = Utils.generateRuntimeId();
    this._background = 0;
    this._positionType = 2;
    this._waitCount = 0;
    this._faceBitmap = null;
    this._textState = null;
    this._textName = new PIXI.Text("",
        {
            align: 'left',
            fontSize: '32px',
            fontFamily: 'GameFont',
            stroke: 'black',
            strokeThickness: 3,
            fontWeight: "bold",
            fill: "#ffffff"
        })
    var padding = this.standardPadding()
    this._textName.position = new Point(padding, 9)
    this.addChild(this._textName)
    this.clearFlags();
};

Window_Message.prototype.updateWait = function () {
    if (this.isFastForward()) return false;
    if (this._waitCount > 0) {
        this._waitCount--;
        return true;
    } else {
        return false;
    }
};

Window_Message.prototype.updateInput = function () {
    if (this.pause && this.isFastForward()) {
        if (!this._textState) {
            this.pause = false;
            this.terminateMessage();
        }
    }
    if (this.isAnySubWindowActive()) {
        return true;
    }
    if (this.pause) {
        if (this.isTriggered()) {
            Input.update();
            this.pause = false;
            if (!this._textState) {
                this.terminateMessage();
            }
        }
        return true;
    }
    return false;
};

Window_Message.prototype.isTriggered = function () {
    return Input.isRepeated('ok') || TouchInput.isRepeated()
}


Window_Message.prototype.isFastForward = function () {
    return Input.isPressed('control')
};


Window_Message.prototype.updateShowFast = function () {
    if (this.isFastForward()) this._showFast = true;
};

Window_Message.prototype.startWait = function (count) {
    this._waitCount = count;
    if (this.isFastForward()) this._waitCount = 0;
};


Window_Message.prototype.windowWidth = function () {
    return Graphics.boxWidth;
};

Window_ChoiceList.prototype.convertEscapeCharacters = function (text) {
    text = this.convertLang(text);
    text = Window_Base.prototype.convertEscapeCharacters.call(this, text);
    return text;
};

Window_Message.prototype.convertEscapeCharacters = function (text) {
    text= this.convertLang(text);
    text = Window_Base.prototype.convertEscapeCharacters.call(this, text);
    text = this.convertExtra(text);
    return text;
};

Window_Base.prototype.convertLang = function (text) {
    text = text.replace(/\\C\<(.*)\>/gi,
        (match, p1) => {
            if (ConfigManager.Language == 'CHI'){
                if($gameParty.inBattle())
                    return $gameTroop._interpreter._comments[0][p1]
                return $gameMap._interpreter._comments[0][p1]
            }
            if ($gameParty.inBattle())
                    return $gameTroop._interpreter._comments[1][p1]
            return $gameMap._interpreter._comments[1][p1]
        }
    )
    text = text.replace(/\\CC\<(.*)\>/gi,
        (match, p1) => {
            if (ConfigManager.Language == 'CHI'){
                return $gameExtraData.tempText[0][p1]
            }
            return $gameExtraData.tempText[1][p1]
        }
    )
    return text;
}

Window_Message.prototype.convertExtra = function (text) {
    text = text.replace(/\x1bN\<(.*)\>/gi,
        (match, p1) => {
            this._textName.text = Window_Base.prototype.convertEscapeCharacters.call(this, p1)
            return ''
        }
    )
    text = text.replace(/\x1bEscape/gi,
        (match, p1) => {
            return '\n'
        }
    )
    return text;
}

Window_Base.prototype.convertEscapeCharacters = function (text) {
    text = text.replace(/\\/g, '\x1b');
    text = text.replace(/\x1b\x1b/g, '\\');
    text = text.replace(/\x1bV\[(\d+)\]/gi, function () {
        return $gameVariables.value(parseInt(arguments[1]));
    }.bind(this));
    text = text.replace(/\x1bV\[(\d+)\]/gi, function () {
        return $gameVariables.value(parseInt(arguments[1]));
    }.bind(this));
    text = text.replace(/\x1bN\[(\d+)\]/gi, function () {
        return this.actorName(parseInt(arguments[1]));
    }.bind(this));
    text = text.replace(/\x1bP\[(\d+)\]/gi, function () {
        return this.partyMemberName(parseInt(arguments[1]));
    }.bind(this));
    text = text.replace(/\x1bG/gi, TextManager.currencyUnit);
    return text;
};

Window_Message.prototype.windowHeight = function () {
    return this.fittingHeight(this.numVisibleRows()) + 44;
};

Window_Message.prototype.terminateMessage = function () {
    this._textName.text=''
    this.close();
    this._goldWindow.close();
    $gameMessage.clear();
};

Window_Message.prototype.numVisibleRows = function () {
    return 3;
};

Window_Message.prototype.newLineX = function () {
    return $gameMessage.faceName() === '' ? 40 : 168;
};

Window_Message.prototype.newPage = function (textState) {
    this.contents.clear();
    this.resetFontSettings();
    this.clearFlags();
    this.loadMessageFace();
    textState.x = this.newLineX();
    textState.y = this._textName.text == " " ? 18 : 36;
    textState.left = this.newLineX();
    textState.height = this.calcTextHeight(textState, false);
};

Window_Message.prototype.needsNewPage = function (textState) {
    return (!this.isEndOfText(textState) &&
        textState.y + textState.height > this.contents.height);
};

Window_Message.prototype.processNormalCharacter = function (textState) {
    var c = textState.text[textState.index];
    var w = this.textWidth(c);
    if (this.newLineX() + textState.x + w >= this.contents.width) {
        this.processNewLine(textState)
        textState.index--
    }
    else {
        this.contents.drawText(c, textState.x, textState.y, w * 2, textState.height);
        textState.x += w;
        textState.index++
    }
};
//-----------------------------------------------------------------------------
// end of Window_Message
//-----------------------------------------------------------------------------

Utils.adjustPicSize = function (bitmap, sprite, height) {
    var scale = height / bitmap.height
    sprite.scale.x = scale
    sprite.scale.y = scale
}

Utils.adjustPicSizeScale = function (sprite, scale) {
    sprite.scale.x = scale
    sprite.scale.y = scale
}

Utils.loadPlotMap = function (filePath) {
    var request = new XMLHttpRequest();
    request.open("GET", filePath);
    request.overrideMimeType('text/plain');
    request.onload = function () {
        if (request.status < 400) {
            Utils.createPlot(request.responseText);
        }
    };
    request.send();
};

Utils.createPlot = function (string) {
    var lines = string.split("\r\n");
    PlotManager.loadLines(lines)
    PlotManager.plotLoadedOk()
};

Utils.reverseDirection = function (direction) {
    let obj = {
        2: 8,
        4: 6,
        6: 4,
        8: 2
    }
    return obj[direction]
};

function PlotManager() {
    throw new Error('This is a static class');
}

PlotManager.initMembers = function (plot, index) {
    if (this._plots[index].plotName == plot) {
        this.setPlot(plot)
        return true
    }
    else {
        this.lines = null
        this._plots[index].plotName =plot
        this.setPlot(plot)
        return false
    }
}

PlotManager.refresh =function(){
    this.extraParam={}
    this.plotEpisodeMap = null
    this.lines = null
    this.currentIndex = null
    this._currentPlot = null
    this.index = null
    this._plots = [
        {
            lines: null,
            plotName: null,
            plotEpisodeMap: null
        },
        {
            lines: null,
            plotName: null,
            plotEpisodeMap: null
        }
    ]
    this.starting = false
}
PlotManager.refresh()


PlotManager.setPlot = function (plot) {
    this._currentPlot = plot
}
PlotManager.plot = function () {
    return this._currentPlot
}

PlotManager.readOneLine = function () {
    if (this._plotContainer)
        this._plotContainer._phase = "readLine"
}

PlotManager.isBusy = function () {
    return this._plotContainer ? this._plotContainer._phase != "pause" && this._plotContainer._phase != "passive" : false
}

PlotManager.loadLines = function (lines) {
    this.lines = lines
    let plot =this._plots[this.index]
    plot.lines=lines
    this.plotEpisodeMap = lines[0].split(',')
    plot.plotEpisodeMap=this.plotEpisodeMap
    this.currentIndex = this.plotEpisodeMap[this.currentIndex] * 1 + 1
}

PlotManager.clearLines = function () {
    this.lines = []
    this.currentIndex = 0
}

PlotManager.registerPlotContainer = function (obj) {
    this._plotContainer = obj
}
PlotManager.removePlotContainer = function () {
    this._plotContainer = null
}

PlotManager.startPlot = function (plot, index,extra) {
    if (this._plotContainer) {
        this.index=0
        this.currentIndex = index
        let flag = this.initMembers(plot,0)
        if (flag) {
            this.currentIndex = this._plots[0].plotEpisodeMap[this.currentIndex] * 1 + 1
            this.lines = this._plots[0].lines
            this.plotEpisodeMap = this._plots[0].plotEpisodeMap
            this._plotContainer.onPlotLoadedOk()
        }
        else {
            this._plotContainer.startPlot();
        }
        this.starting=true
        if(extra){
            this.extraParam=extra
        }
    }
}

PlotManager.startPlotCommon = function (plot, index) {
    if (this._plotContainer) {
        this.index = 1
        this.currentIndex = index
        let flag = this.initMembers(plot,1)
        if (flag) {
            this.currentIndex = this._plots[1].plotEpisodeMap[this.currentIndex] * 1 + 1
            this.lines = this._plots[1].lines
            this.plotEpisodeMap = this._plots[0].plotEpisodeMap
            this._plotContainer.onPlotLoadedOk()
        }
        else {
            this._plotContainer.startPlot();
        }
        this.starting = true
    }
}

PlotManager.endPlot = function () {
    if (this._plotContainer) {
        this._plotContainer.endPlot();
    }
    this.starting=false
}
PlotManager.plotLoadedOk = function () {
    if (this._plotContainer)
        this._plotContainer.onPlotLoadedOk();
}

PlotManager.jumpPlot = function (index) {
    this.currentIndex += index
    this.readOneLine()
}

PlotManager.jumpPlotTo = function (index) {
    this.currentIndex = this.plotEpisodeMap[index] * 1 + 1
    this.readOneLine()
}

PlotManager.jumpPlotToTag = function (tag) {
    while(this.currentIndex<this.lines.length){
        let line = this.lines[this.currentIndex]
        let arr = line.split('@')
        if(arr[0]==tag) {
            this.currentIndex++
            this.readOneLine()
            return true
        }
        this.currentIndex++
    }
    return false
}

PlotManager.processLine = function () {
    if (this.currentIndex == this.lines.length) {
        this.endPlot()
        return
    }
    var line = this.lines[this.currentIndex++]
    var arr = line.split('@')
    this.processParam(arr)
}

PlotManager.processParam=function(arr){
    switch (arr[0]) {
        case "wa": {
            this._plotContainer.setwaitTime(arr[1], 0)
            break;
        }
        case "sm": {
            this._plotContainer.showText(...arr.slice(1), 1)
            break;
        }
        case "smc": {
            this._plotContainer.showTextCenter(arr[1])
            break;
        }
        case "end": {
            this.endPlot()
            break;
        }
        case "jp": {
            this.jumpPlot(arr[1])
            break;
        }
        case "jpto": {
            this.jumpPlotTo(arr[1] - 1)
            break;
        }
        case "jptag":{
            this.jumpPlotToTag(arr[1])
            break;
        }
        case "op": {
            this._plotContainer.showChoicesList(eval(arr[1]), eval(arr[2]))
            break;
        }
        case 'pa': {
            this._plotContainer.waitForInterpreter()
            break
        }
        case "ce": {
            this._plotContainer.changeEmote(...arr.slice(1))
            break;
        }
        case "ces": {
            $gameExtraStatus.changeEmote(arr[1])
            this.readOneLine()
            break;
        }
        case "cc": {
            this._plotContainer.changeCloth(...arr.slice(1))
            break;
        }
        case "cp": {
            this._plotContainer.changePrefix(...arr.slice(1))
            break;
        }
        case "sw": {
            this._plotContainer.showCharacter(...arr.slice(1), 1)
            break;
        }
        case "swi": {
            this._plotContainer.showCharacter(...arr.slice(1), 0)
            break;
        }
        case "hd": {
            this._plotContainer.hideCharacter(arr[1])
            break;
        }
        case "ap": {
            this._plotContainer.displayCharacter(arr[1])
            break;
        }
        case "ex": {
            this._plotContainer.exitCharacter(arr[1])
            break;
        }
        case 'cn': {
            this._plotContainer.changeName([arr[1]], arr[2])
            break
        }
        case 'cg': {
            this._plotContainer.showCG(...arr.slice(1))
            break
        }
        case 'cl':{
            $gameScreen.clearPictures()
            this.readOneLine()
            break;
        }
        case 'script':{
            eval(arr[1])
            this.readOneLine()
            break
        }
        case 'if': {
            if (eval(arr[1])) {
                this.processParam(arr.slice(2))
            }
            else{
                this.readOneLine()
            }
            break
        }
        case 'ef':{
            this._plotContainer.attachEffectToStand(arr[1],arr[2],arr[3])
            this.readOneLine
        }
        default:{
            this.readOneLine()
        }
    }
}

Scene_Map.prototype.createDisplayObjects = function () {
    this.createSpriteset();
    this.createPlotLayer();
    this.createMapNameWindow();
    this.createWindowLayer();
    this.createAllWindows();
};

Scene_Map.prototype.createPlotLayer = function () {
    this._plotLayer = new PlotMapContainer();
    this.addChild(this._plotLayer);
    PlotManager.registerPlotContainer(this._plotLayer)
}

function PlotMapContainer() {
    this.initialize.apply(this, arguments);
}

PlotMapContainer.prototype = Object.create(PIXI.Container.prototype);
PlotMapContainer.prototype.constructor = PlotMapContainer;

PlotMapContainer.prototype.initialize = function () {
    this._phase = 'passive'
    PIXI.Container.call(this);
    this.initMembers()
}


PlotMapContainer.prototype.initMembers = function () {
    this._standDraws = []
    for (let i = 0; i < 4; i++) {
        let standDraw = new Sprite_DrawStandPlotMap(i)
        this._standDraws.push(standDraw)
        this.addChild(standDraw)
    }
    this._waitTime = 0
    this._weight = 0;
}


PlotMapContainer.prototype.update = function () {
    if (this._phase == 'passive' || $gameMessage.isBusy())
        return
    switch (this._phase) {
        case "active": {//開始激活
            this._phase = "runing"
            Utils.loadPlotMap(`data/${ConfigManager.Language}/${PlotManager.plot()}.txt`)
            break
        }
        case "start": {
            this._phase = "readLine"
            break;
        }
        case "readLine": {
            this.startReadLine();
            break;
        }
        case "input": {
            this.checkInput();
            break;
        }
        case "pause": { //暂停
            break;
        }
        case "wait": { //等待一段时间
            this.WaitTimePass(0);
            break;
        }
        case "wait2": { //等待一段时间，等待操作
            this.WaitTimePass(1);
            break;
        }
        case "renderText": {//渲染文字
            this.renderingText()
            break;
        }
        case "effect": {//等待一些动画完成
            this._phase = "input"
            break;
        }
    }
    this.children.forEach(function (child) {
        if (child.update) {
            child.update();
        }
    });
};


PlotMapContainer.prototype.hideCharacter = function (position) {
    var standDraw = this._standDraws[position]
    standDraw.hide()
    this._phase = "readLine"
}


PlotMapContainer.prototype.displayCharacter = function (position) {
    var standDraw = this._standDraws[position]
    standDraw.show()
    this._phase = "readLine"
}

PlotMapContainer.prototype.exitCharacter = function (position) {
    var target = position < 2 ? -300 : Graphics.width + 300
    var standDraw = this._standDraws[position]
    standDraw.setTarget(target, 45, 1)
    this.setwaitTime(45, 0)
}

PlotMapContainer.prototype.attachEffectToStand = function (position, key, value) {
    var standDraw = this._standDraws[position]
    if (!standDraw[key]) {
        standDraw[key] = new Sprite_Base()
    }
    switch (value) {
        case 'patch': {
            for (let i = 124; i <= 128; i++) {
                if ($gameSwitches.value(i)) {
                    standDraw[key].bitmap = ImageManager.loadPicture(`patch${i - 124}`)
                    standDraw[key].anchor = new Point(0.5,0.5)
                    standDraw.addChild(standDraw[key])
                    break;
                }
            }
            break;
        }
        default: {
            standDraw[key].bitmap = null
        }
    }
}

PlotMapContainer.prototype.startPlot = function () {
    this._phase = 'active'
};

PlotMapContainer.prototype.showChoicesList = function (choices,JumpIndexs) {
    this._phase = 'runing'
    $gameMessage.setChoices(choices, 0, -1);
    $gameMessage.setChoiceCallback(n => {
        PlotManager.jumpPlot(JumpIndexs[n])
        PlotManager.readOneLine()
    })
};

PlotMapContainer.prototype.showCG = function(id,name,opacity,mode){
    let picId=Number(id)
    let alpha=Number(opacity)
    $gameScreen.showPicture(picId,name,0,0,0,100,100,alpha,0)
    /*if(picId>1){
        $gameScreen.erasePicture(picId-1)
    }*/
    if(mode==1){
        $gameScreen.movePicture(picId,name,0,0,0,100,100,255,0,60)
        this.setwaitTime(60,0)
    }
    else{
        this._phase = 'readLine'
    }
}

PlotMapContainer.prototype.endPlot = function () {
    this._standDraws.forEach((item,index) => {
        item._data={
            prefix: null,
            cloth: null,
            emote: null,
            status: 1,
            position: ([0, 1].indexOf(index) != -1) ? new Point(-300, 640) : new Point(Graphics.width + 300, 640),
            name: " ",
            tint: 0xFFFFFF,
            visible: false
        }
        item.tint=0xFFFFFF
        item.children.forEach(i => i.tint = 0xFFFFFF)
        item.hide()
    })
    this.parent._messageWindow.terminateMessage()
    $gameMessage.clear()
    this._phase = 'passive'
};

PlotMapContainer.prototype.onPlotLoadedOk = function () {
    this._phase = 'start'
};

PlotMapContainer.prototype.waitForInterpreter = function () {
    this._phase = "pause"
}

PlotMapContainer.prototype.checkInput = function () {
    if (Input.isTriggered('ok') || TouchInput.isTriggered() || Input.isRepeated('control')) {
        this._phase = 'readLine'
    }
}

PlotMapContainer.prototype.startReadLine = function () {
    this._phase = "runing"
    PlotManager.processLine()
}

PlotMapContainer.prototype.setwaitTime = function (value, mode) {
    this._phase = mode == 0 ? "wait" : "wait2"
    this._waitTime = value
}

PlotMapContainer.prototype.WaitTimePass = function (mode) {
    this._waitTime--
    if (this._waitTime <= 0) {
        this._phase = mode == 0 ? "readLine" : "input"
    }
}

PlotMapContainer.prototype.showText = function (name, text, mode) {
    $gameMessage.setPositionType(2)
    $gameMessage.setBackground(0);
    text = text.replace(/\<N(\d+)\>/gi,
        (match, p1) => {
            return this._standDraws[p1].actorName
        }
    )
    if (["0", "1", "2", "3"].indexOf(name) != -1) {
        let standDraw = this._standDraws[name]
        this.brightenCharacter(name)
        this.setChildIndex(standDraw,3)
        $gameMessage.add(`\\n<${standDraw.actorName}>` + text)
        for (let i = 0; i < 4; i++) {
            if (i != name){
                this.blackenCharacter(i)
                this.setChildIndex(this._standDraws[i],0)
            }
        }
    }
    else {
        $gameMessage.add(`\\n<${name}>` + text)
        if (mode == 1) {
            for (let i = 0; i < 4; i++) {
                this.blackenCharacter(i)
            }
        }
    }
    this._phase = "readLine"
}

PlotMapContainer.prototype.showTextCenter = function (text) {
    $gameMessage.setPositionType(1)
    $gameMessage.setBackground(1);
    $gameMessage.add(`\\n< >` + text)
    this._phase = "readLine"
}

PlotMapContainer.prototype.changeName = function (position, name) {
    var standDraw = this._standDraws[position]
    standDraw.actorName = name;
    this._phase = "readLine"
}


PlotMapContainer.prototype.changeEmote = function (position, emote) {
    var standDraw = this._standDraws[position]
    standDraw.m_changeStatus('emote', emote)
    this._phase = "readLine"
}

PlotMapContainer.prototype.changeCloth = function (position, cloth) {
    var standDraw = this._standDraws[position]
    standDraw.m_changeStatus('cloth', cloth)
    this._phase = "readLine"
}


PlotMapContainer.prototype.changePrefix = function (position, prefix) {
    var standDraw = this._standDraws[position]
    standDraw.m_changeStatus('prefix', prefix)
    this._phase = "readLine"
}


PlotMapContainer.prototype.showCharacter = function (prefix, position, emote = null, cloth = null, name = '', mode = 1) {
    var standDraw = this._standDraws[position]
    standDraw.actorName = name
    var target = position < 2 ? position * 128 + 264 : Graphics.width + (position - 3) * 128 - 264
    let definedCloth=cloth
    if(cloth=="default"){
        definedCloth=$gameSwitches.value(101)?"C2":"C1"
    }
    standDraw.loadBitmap(prefix, emote, definedCloth)
    standDraw.show()
    standDraw.setTarget(target, 45, 0)
    this.setwaitTime(45, 0)
}


Game_Interpreter.prototype.updateWait = function () {
    return this.updateWaitCount() || this.updateWaitMode() || PlotManager.isBusy();
};


function Sprite_DrawStandPlotMap() {
    this.initialize.apply(this, arguments)
}


Sprite_DrawStandPlotMap.prototype = Object.create(Sprite_Base.prototype);
Sprite_DrawStandPlotMap.prototype.constructor = Sprite_DrawStandPlotMap;
Object.defineProperties(Sprite_DrawStandPlotMap.prototype, {
    cPrefix: {
        get: function () { return this._data.prefix; }, set: function (value) {
            this._data.prefix = value
        }, configurable: true
    },
    cEmote: {
        get: function () { return this._data.emote; }, set: function (value) {
            this._data.emote = value
        }, configurable: true
    },
    cCloth: {
        get: function () { return this._data.cloth; }, set: function (value) {
            this._data.cloth = value
        }, configurable: true
    },
    actorName: {
        get: function () { return this._data.name },
        set: function (value) { this._data.name = value },
        configurable: true
    },
    status: {
        get: function () { return this._data.status },
        set: function (value) { this._data.status = value },
        configurable: true
    },
    pos: {
        get: function () { return this._data.position },
        set: function (value) { this._data.position = value; this.position = value },
        configurable: true
    },
    posX:{
        get: function () { return this._data.position.x },
        set: function (value) { this._data.position.x = value; this.position.x = value },
        configurable: true
    }
})
Sprite_DrawStandPlotMap.prototype.initialize = function (position) {
    Sprite_Base.prototype.initialize.call(this);
    this.anchor = new Point(0.5, 0.5)
    this._position = position
    this._data = {
        name:'',
        prefix: null,
        cloth: null,
        emote: null,
        status: 1,
        position: ([0, 1].indexOf(position) != -1) ? new Point(-300, 640) : new Point(Graphics.width + 300,640),
        tint: 0xFFFFFF,
        visible: false
    }
    this.initMembers()
}

Sprite_DrawStandPlotMap.prototype.initMembers = function () {
    this._emote = new Sprite_Base()
    this._cloth = new Sprite_Base()
    this._emote.anchor = new Point(0.5, 0.5)
    this._cloth.anchor = new Point(0.5,0.5)
    this.addChild(this._cloth)
    this.addChild(this._emote)
    this._duration = 0
    this._denominator = 0
    this._target = 0
    this.position = this._data.position
    this._hiding = !this._data.visible;
    this.updateVisibility();
    let tint=this._data.tint
    this.tint = tint
    this.children.forEach(item => item.tint = tint)
}

Sprite_DrawStandPlotMap.prototype.hide = function () {
    this._data.visible=false;
    this._hiding = true;
    this.updateVisibility();
};

Sprite_DrawStandPlotMap.prototype.show = function () {
    this._data.visible = true;
    this._hiding = false;
    this.updateVisibility();
};

Sprite_DrawStandPlotMap.prototype.refreshEmote = function () {
    if (this.cPrefix && this.cEmote)
        this._emote.bitmap = ImageManager.loadPicture(`${this.cPrefix}_${this.cEmote}`)
}

Sprite_DrawStandPlotMap.prototype.refreshCloth = function () {
    if (this.cPrefix && this.cCloth){
        this._cloth.bitmap = ImageManager.loadPicture(`${this.cPrefix}_${this.cCloth}`)
    }
}

Sprite_DrawStandPlotMap.prototype.refreshPrefix = function () {
    if (!this.cPrefix)
        return
    var prefix = this.cPrefix
    this.bitmap = ImageManager.loadPicture(prefix)
    this.bitmap.addLoadListener(() => {
        if (this._position < 2)
            this.scale.x = -Math.abs(this.scale.x)
    })
}

Sprite_DrawStandPlotMap.prototype.loadBitmap = function (prefix = null, emote = null, cloth = null) {
    this.cPrefix = prefix
    this.cCloth = cloth
    this.cEmote = emote
    this.refreshPrefix()
    this.refreshCloth()
    this.refreshEmote()
}



Sprite_DrawStandPlotMap.prototype.updateMove = function () {
    if (this._duration > 0) {
        var d = this._duration;
        var target = this._target
        var x = this.posX
        this.posX= (x * (d - 1) + target) / d
        if (this.status == 0) {
            this.opacity = 255 * (this._denominator - d) / this._denominator
        }
        else if (this.status == 1) {
            this.opacity = 255 * (1 - (this._denominator - d) / this._denominator)
        }
        this._duration--;
    }
    else{
        if(this.status==1){
            this.status=2
            this.bitmap=null
            this.children.forEach(item=>{
                item.bitmap=null
            })
        }
    }
}

Sprite_DrawStandPlotMap.prototype.setTarget = function (position, duration, status) {
    this._target = position
    this._duration = duration
    this._denominator = duration
    this.status = status
}

Sprite_DrawStandPlotMap.prototype.update = function () {
    Sprite_Base.prototype.update.call(this)
    this.updateMove()
}


Sprite_DrawStandPlotMap.prototype.setTint = function (tint) {
    this._data.tint=tint
    this.tint = tint
    this.children.forEach(item => item.tint = tint)
};

Sprite_DrawStandPlotMap.prototype.m_changeStatus = function (status, value) {
    if (status == 'prefix') {
        this.cPrefix = value
        this.refreshPrefix()
        return
    }
    if (status == 'emote') {
        this.cEmote = value
        this.refreshEmote()
        return
    }
    if (status == 'cloth') {
        this.cCloth = value
        this.refreshCloth()
        return
    }
}

PlotMapContainer.prototype.blackenCharacter = function (position) {
    var standDraw = this._standDraws[position]
    if (standDraw.status == 2 || standDraw.status == 1)
        return
    var targetX = position < 2 ? position * 128 + 248 : Graphics.width + (position - 3) * 128 - 248
    var targetY = 648
    standDraw.setTint(0x999999)
    standDraw.pos = new Point(targetX, targetY)
}

PlotMapContainer.prototype.brightenCharacter = function (position) {
    var standDraw = this._standDraws[position]
    if (standDraw.status == 2 || standDraw.status == 1)
        return
    var targetX = position < 2 ? position * 128 + 264 : Graphics.width + (position - 3) * 128 - 264
    var targetY = 640
    standDraw.setTint(0xFFFFFF)
    standDraw.pos = new Point(targetX, targetY)
}